export default {
  'inside-commons': {
    banner: {
      html: true,
      imageKey: 'image'
    }
  },
  'inside-events': {
    rootRoute: {
      fr: 'agenda'
    }
  },
  'inside-ged': {
    rootRoute: {
      fr: 'phototheque'
    }
  },
  'inside-customs': {
    templates: {
      fullContent: {
        newArrivals: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-users': {
    shortcuts: {
      max: 4,
      content: 'tools_shortcuts'
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [] }
      ]
    },
    e2e: {
      userNav: ['profile', 'bookmarks', 'shortcuts', 'logout']
    }
  },
  'inside-tools': {
    rootRoute: {
      fr: 'outils-de-communication'
    }
  },
  'inside-newcomers': {
    rootRoute: {
      fr: 'nouveaux-arrivants'
    }
  },
  globals: {
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  }
}
