import { http } from '@inside-library/helpers/Http'

const fetchMeryCategories = async ({ $route }) => {
  try {
    const { slug } = $route.params

    const { data } = await http.get('content/mery_categories', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        'content',
        'chapo',
        'slug',
        {
          mery_pages: {
            fields: ['uuid', 'title', 'slug', 'content_type', 'chapo'],
            filters: { reverse: true }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchMeryPages = async ({ $route }) => {
  try {
    const { page } = $route.params

    const { data } = await http.get('content/mery_pages', {
      fields: [
        'uuid',
        'title',
        'content',
        'content_type',
        'admin',
        'chapo',
        'slug',
        'mery_pages_icon',
        {
          mery_categories: {
            fields: ['uuid', 'slug', 'title']
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': page
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchMeryCategories, fetchMeryPages }
