import { http } from '@inside-library/helpers/Http'

const fetchLinkPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/link_pages', {
      fields: ['uuid', 'title', 'content_type', 'admin', 'content'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchLinkPage }
