<?php

namespace Inside\IMER\Listeners;

use Inside\Events\InsideBooted;
use Inside\Facades\Inside;

class AddPushNotifications
{
    public function handle(InsideBooted $event): void
    {
        $key = env("WONDERPUSH_KEY");
        if (!$key) {
            return;
        }
        $wonderPush = <<<SCRIPT
 window.WonderPush = window.WonderPush || [];
    WonderPush.ready = WonderPush.push;
    WonderPush.push(["init", {
        webKey: '$key',
    }]);
SCRIPT;
        Inside::js("https://cdn.by.wonderpush.com/sdk/1.1/wonderpush-loader.min.js");
        Inside::script($wonderPush);
    }
}
