<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixNotificationIsFeatured extends Migration
{
    public function up(): void
    {
        $notificationTypes = NotificationType::query()
            ->where('condition', 'is_featured:1|status:1')
            ->where('model', 'Inside\Content\Models\Contents\News')
            ->where('action', 'createOrUpdate')
            ->get();

        $notificationTypes->each(function ($notificationType) {
            $notificationType->action = 'create';
            $notificationType->save();
        });
    }

    public function down(): void
    {
    }
}
