<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\MeryPages;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ReplaceIconFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'mery_pages',
            'mery_pages_icon',
            [
                'name' => 'mery_pages_icon',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'search_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Icône',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            4
        );

        $contents = MeryPages::query()->get();
        $bridgeContent = new BridgeContent();
        foreach ($contents as $content) {
            if (empty($content->icon) || empty($content->uuid)) {
                continue;
            }

            $bridgeContent->contentUpdate('mery_pages', [
                'uuid' => $content->uuid,
                'mery_pages_icon' => $content->icon
            ]);
        }

        $bridge->contentTypeDeleteField('node', 'mery_pages', 'icon');
        $bridge->contentTypeDeleteField('node', 'tools', 'icon');

        Artisan::call('models:rebuild');
        $bridge->contentTypeCreateField('tools', 'icon', [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Icône',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ], 4);
    }
}
