<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\ShortcutsMenus;
use Inside\Content\Models\Contents\ToolsShortcuts;
use Inside\Host\Bridge\BridgeContent;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Output\ConsoleOutput;

class GetShortcutsOutOfDrupal extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('tools_shortcuts');
        $this->migrateContent('users');

        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();
        $shortcuts = ShortcutsMenus::all();

        foreach ($shortcuts as $shortcut) {
            $uuid = null;
            $tool = ToolsShortcuts::query()
                ->where('title', $shortcut->title)
                ->where('link', $shortcut->link)
                ->where('langcode', $shortcut->langcode)
                ->first();

            if (empty($tool)) {
                $data = [
                    'bundle' => 'tools_shortcuts',
                    'link' => $shortcut->link,
                    'title' => $shortcut->title,
                    'image' => $shortcut->image,
                    'author' => $shortcut->author,
                    'type' => 'node',
                ];
                $uuid = $bridge->contentInsert('tools_shortcuts', $data);
            } else {
                $uuid = $tool->uuid;
            }

            $users = $shortcut->reverseUsers;

            $output = new ConsoleOutput();
            $bar = new ProgressBar($output, $users->count());
            $bar->setFormat("%message%\n %current%/%max% [%bar%] %percent:3s%%");
            $bar->setMessage("Converting " . $shortcut->title . " shortcut for " . $users->count() . " users");
            $bar->start();

            foreach ($users as $user) {
                $tools = $user->toolsShortcuts;
                if (!$tools) {
                    continue;
                }
                $tools = $tools->pluck('uuid')->toArray();
                if (!in_array($uuid, $tools)) {
                    $tools[] = $uuid;
                    $bridge->contentUpdate('users', [
                        'uuid' => $user->uuid,
                        'tools_shortcuts' => $tools
                    ]);
                }
                $bar->advance();
            }
        }
    }

    public function down(): void
    {
    }
}
