<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateLifestyleContents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $lifestyle_categories = include __DIR__ . '/contents/lifestyle_categories.php';

        try {
            $bridge->contentTypeUpdateOrCreate(
                $lifestyle_categories['options']['name'],
                $lifestyle_categories['options'],
                $lifestyle_categories['fields']
            );
        } catch (\Exception $e) {
            dd($e);
        }

        $lifestyle_contents = include __DIR__ . '/contents/lifestyle_contents.php';

        try {
            $bridge->contentTypeUpdateOrCreate(
                $lifestyle_contents['options']['name'],
                $lifestyle_contents['options'],
                $lifestyle_contents['fields']
            );
        } catch (\Exception $e) {
            dd($e);
        }
    }

    public function down(): void
    {
    }
}
