<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => (count(list_languages()) > 1),
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'new_arrivals',
        'title'             => [
            'fr' => 'Nouveaux arrivants',
        ],
    ],
    'fields'  => [
        // Utilisateur
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'newcomer',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Nouvel arrivant',
            ],
            'description'         => [
                'fr' => 'L\'utilisateur qui vient d\'arriver',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'users',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
            ],
        ],
        // Espaces
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'spaces',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Espaces',
            ],
            'description'         => [
                'fr' => 'L\'espace rattaché à l\'utilisateur',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'spaces',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Contenu
        [
            'type'                => BridgeContentType::SECTION_FIELD,
            'name'                => 'content',
            'searchable'          => true,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Contenu',
            ],
            'description'         => [
                'fr' => 'Paragraphes',
            ],
            'settings'            => [
                'target_type' => [
                    'cta',
                    'file',
                    'html',
                    'image',
                    'map',
                    'text',
                    'text_with_image',
                    'video',
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
