<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

/**
 * Get the structure id for a user
 *
 * @param array $record
 * @param BridgeContent $bridge
 * @param string $bundle
 * @param string $column
 *
 * @return array|null
 * @throws Exception
 */
function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
{
    $name = $record[$column];
    if (empty($name)) {
        return null;
    }

    $query = call_user_func('Inside\\Content\\Models\\Contents\\'.Str::studly($bundle).'::query');

    $entity = $query->where('title', $name)->first();

    if ($entity) {
        return ['target_id' => $entity->uuid];
    }

    $uuidBridge = $bridge->contentInsert($bundle, [
        'title' => $name,
        'type' => 'node',
        'bundle' => $bundle,
        'uid' => 1,
    ]);

    if ($uuidBridge) {
        return ['target_id' => $uuidBridge];
    }

    return null;
}

function get_name(array $record, BridgeContent $bridge, int $index): ?string
{
    $name = explode(',', $record['NOM,PRENOM'] ?? '');

    return $name[$index] ?? null;
}

return [
    'files' => [
        'mercialys' => [
            'path' => __DIR__.'/../../../../imports/mercialys.csv',
            'separator' => ';',
            'fields' => [
                'name' => 'MATRICULE',
                'mail' => 'ADRESSE MAIL',
                'firstname' => function ($record, BridgeContent $bridge) {
                    return get_name($record, $bridge, 1);
                },
                'lastname' => function ($record, BridgeContent $bridge) {
                    return get_name($record, $bridge, 0);
                },
                'phone' => 'TELEPHONE FIXE',
                'mobile_phone' => 'TELEPHONE MOBILE',
                'services' => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'services', 'SERVICE');
                },
                'locations' => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'locations', 'LIEU');
                },
                'function' => 'FONCTION',
            ],
        ],
    ],
];
