<?php

namespace Inside\IMER\Providers;

use Inside\IMER\Listeners\AddPushNotifications;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Illuminate\Support\Facades\Event;
use Inside\Events\InsideBooted;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * IMER Service provider.
 *
 * @category Class
 * @package  Inside\IMER\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        InsideBooted::class => [
            AddPushNotifications::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/feed.php', 'feed');
            $this->mergeConfigTo(__DIR__.'/../../config/security.php', 'security');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/app.php', 'app');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
