<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'categorizable'     => true,
        'permissible'       => true,
        'name'              => 'lifestyle_contents',
        'title'             => [
            'fr' => 'Contenu vie pratique',
        ],
    ],
    'fields'  => [
        // Image
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Image',
            ],
            'description'         => [
                'fr' => 'L\image illustrant le contenu',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [],
            ],
        ],
        // Contenu
        [
            'type'                => BridgeContentType::SECTION_FIELD,
            'name'                => 'content',
            'searchable'          => true,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Contenu',
            ],
            'description'         => [
                'fr' => 'Paragraphes',
            ],
            'settings'            => [
                'target_type' => [
                    'cta',
                    'file',
                    'html',
                    'image',
                    'map',
                    'text',
                    'text_with_image',
                    'video',
                ],
            ],
            'widget'      => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [],
            ],
        ],
        // Catégorie
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'lifestyle_categories',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Catégorie',
            ],
            'description'         => [
                'fr' => 'La catégorie de vie pratique',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'lifestyle_categories',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
