<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsWeightAndIcon extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $types = ['spaces_pages', 'spaces_pages_categories'];

        foreach ($types as $type) {
            $bridge->contentTypeCreateOrUpdateField($type, 'weight', [
                'name' => 'weight',
                'type' => BridgeContentType::INTEGER_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Poids',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]);
        }

        $bridge->contentTypeCreateOrUpdateField('spaces_pages_categories', 'icon', [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
    }
}
