<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\ToolsShortcuts;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ReplaceMachineNameLinkInToolsShortcuts extends Migration
{
    public function up(): void
    {
        if (!Schema::hasContentType('tools_shortcuts')) {
            return;
        }
        $bridgeType = new BridgeContentType();
        $bridge = new BridgeContent();

        $bridgeType->contentTypeCreateOrUpdateField('tools_shortcuts', 'tools_link', [
            'name' => 'tools_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        foreach (ToolsShortcuts::get() as $tool) {
            $bridge->contentUpdate('tools_shortcuts', [
                'uuid' => $tool->uuid,
                'author' => $tool->author,
                'tools_link' => $tool->link
            ]);
        }

        $bridgeType->contentTypeDeleteField('node', 'tools_shortcuts', 'link');
    }

    public function down(): void
    {
    }
}
