<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\LinkPages;
use Inside\Host\Bridge\BridgeContentType;

class AddEndDateFieldsOnEventsContent extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        if (!InsideSchema::hasField('events', 'end_date')) {
            $weight = $bridge->getFreeSpaceAfter('events', 'date');
            try {
                $bridge->contentTypeCreateField(
                    'events',
                    'end_date',
                    [
                        'type' => BridgeContentType::TIMESTAMP_FIELD,
                        'name' => 'end_date',
                        'searchable' => false,
                        'translatable' => false,
                        'search_result_field' => false,
                        'required' => false,
                        'weight' => $weight,
                        'title' => [
                            'fr' => 'Date de fin',
                        ],
                        'description' => [
                            'fr' => 'La date de fin de l \'evenement',
                        ],
                        'default' => null,
                        'settings' => [
                            'cardinality' => 1,
                        ],
                        'widget' => [
                            'type' => BridgeContentType::TIMESTAMP_WIDGET,
                            'settings' => [],
                        ],
                    ],
                    $weight
                );
            } catch (\Exception $e) {
                dd($e);
            }
        }
    }

    public function down(): void
    {
        $bridge = new BridgeContentType();
        if (InsideSchema::hasField('events', 'end_date')) {
            $bridge->contentTypeDeleteField(
                'node',
                'events',
                'end_date'
            );
        }
    }
}
