<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

/**
 * @param mixed $user
 * @param BridgeContent $bridge
 * @param string $attribute
 * @param string $contentType
 * @return string|null
 * @throws Exception
 */
function get_entity_reference($user, BridgeContent $bridge, string $attribute, string $contentType): ?string
{
    $uuid = null;
    if (!$user->{$attribute}) {
        return null;
    }

    $title = $user->{$attribute};


    $entity = call_user_func(type_to_class($contentType).'::query')
        ->where('title', $title)->first();
    if ($entity) {
        $uuid = $entity->uuid;
    } else {
        $uuid = $bridge->contentInsert($contentType, [
            'type' => 'node',
            'bundle' => $contentType,
            'title' => $title,
        ]);
    }

    return $uuid;
}

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'firstname' => function ($user) {
            return Str::ucfirst(Str::lower($user->givenName));
        },
        'lastname' => 'surname',
        'function' => 'jobTitle',
        'phone' => function ($user) {
            $phone = implode(", ", $user->businessPhones);
            if (empty($phone)) {
                return " ";
            }

            return $phone;
        },
        'mobile_phone' => 'mobilePhone',
        'locations' => function ($user, BridgeContent $bridge) {
            return get_entity_reference($user, $bridge, 'city', 'locations');
        },
        'services' => function ($user, BridgeContent $bridge) {
            return get_entity_reference($user, $bridge, 'department', 'services');
        },
        'langcode' => function () {
            return 'fr';
        },
        'status' => fn ($user) => $user->jobTitle && $user->department,
        'upn' => 'userPrincipalName',
    ],
];
