import { http } from '@inside-library/helpers/Http'

export default {
  spacesPages: {
    fields: ['uuid', { spaces_pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacePagesPage',
      params: { slug: data.spaces_pages_categories.spaces.data[0].slug[0] }
    }),
    delete: async ({ data }) => {
      return {
        name: 'SpacePage',
        params: { slug: data.spaces_pages_categories.spaces.data[0].slug[0] }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPagesCategories } = await http.get(
        'content/spaces_pages',
        {
          fields: ['uuid', { spaces_pages_categories: ['uuid', 'title'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: space } = await http.get(
        'content/spaces_pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: {
            'uuid:eq': spacesPagesCategories[0].spaces_pages_categories.uuid
          }
        }
      )

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: space[0].spaces.data[0].slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  spacesPagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.data[0].slug[0] }
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  pagesGroups: {
    add: ({ data }) => ({
      name: 'GroupPagePage',
      params: { slug: data.slug[0] }
    }),
    delete: async ({ uuid }) => {
      const { data } = await http.get('content/pages_groups', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': uuid }
      })
      return {
        name: 'GroupPageListingPage',
        params: { slug: data[0].pages_groups }
      }
    }
  }
}
