import { http } from '@inside-library/helpers/Http'
import { newsFields, userFields } from '../constants'

export const fetchFeaturedNews = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: newsFields,
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        sort: 'updated_at:desc',
        'archived:eq': 0
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchGroupPagePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/pages_groups', {
      fields: [
        'uuid',
        'published_at',
        'title',
        'slug',
        'status',
        'image_app',
        'link',
        'content_type',
        'admin',
        'content'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'body',
        'image',
        'slug',
        'content_type',
        'admin',
        {
          users: {
            fields: userFields,
            filters: { sort: 'lastname:asc' }
          }
        },
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'slug',
              'background_color',
              'icon',
              'image',
              'link',
              'content_type',
              'admin',
              'dark_mode',
              'link_label',
              'weight'
            ],
            filters: { 'archived:eq': 0 }
          }
        },
        {
          folders: {
            fields: [
              'uuid',
              'title',
              {
                documents: {
                  fields: [
                    'uuid',
                    'title',
                    'file',
                    'has_section',
                    'admin',
                    'content_type',
                    'published_at'
                  ],
                  filters: {
                    reverse: true,
                    sort: 'published_at:desc',
                    'archived:eq': 0
                  }
                }
              }
            ],
            filters: { 'archived:eq': 0 }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: newsFields,
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'published_at:lte': 'now()',
                    sort: 'published_at:desc',
                    'archived:eq': 0,
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0
            }
          }
        },
        {
          spaces_pages_categories: {
            fields: ['count'],
            filters: { reverse: true, 'archived:eq': 0 }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacePagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'body'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
