import GroupPagePage from '../pages/GroupPagePage'

import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'

import { fetchSpace, fetchGroupPagePage, fetchSpacePagesPage } from '../fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    component: () => import('../pages/GedPage')
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/NewsListingPage')
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpace)
  },
  {
    name: 'SpacePagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpacePagesPage)
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'GroupPageListingPage',
    path: '/page-groupe',
    component: () => import('../pages/GroupPageListingPage')
  },
  {
    name: 'GroupPagePage',
    path: '/page-groupe/:slug',
    component: withFetch(GroupPagePage, { size: 'xxl' })(fetchGroupPagePage)
  },
  {
    name: 'HRNewsListingPage',
    path: '/actualites-rh',
    component: () => import('../pages/HRNewsListingPage')
  }
]
