export default {
  globals: {
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-administration': {
    subModules: ['inside-mailings']
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-ged': {
    useV2: true,
    rootRoute: {
      fr: 'documents'
    }
  },
  'inside-news': {
    showBookmarks: false,
    minimalDate: true
  },
  'inside-users': {
    shortcuts: {
      max: 5
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-events': {
    printEnabled: true
  }
}
