<?php

namespace Inside\IIMU\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Class ServiceProvider
 *
 * @package Inside\IIMU\Providers
 */
class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/google.php', 'google');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigFrom(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
