<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => true,
        'name'              => 'groups_folders',
        'title'             => [
            'fr' => 'Dossiers de groupe',
            'en' => 'Groups\'s folders',
        ],
    ],
    'fields'  => [
        // Groupe
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'groups',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Groupe',
                'en' => 'Group',
            ],
            'description'         => [
                'fr' => 'Le groupe',
                'en' => 'group',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'groups',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Parent
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'groups_folders',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'classifiable'        => 'groups',
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Parent',
                'en' => 'Parent',
            ],
            'description'         => [
                'fr' => 'Le parent du dossier',
                'en' => 'Folder\'s parent',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'groups_folders',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
