<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Facades\Schema as InsideSchema;

class SeedCustomBirthdayNewcomer extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        if (!InsideSchema::hasContentType('custom')) {
            return;
        }

        $bridge->contentInsert(
            type: 'custom',
            data: [
                'langcode' => 'fr',
                'title' => 'Anniversaires',
                'custom_slug' => 'birthdays',
                'redirection_page' => 'BirthdaysListingPage',
            ],
        );

        $bridge->contentInsert(
            type: 'custom',
            data: [
                'langcode' => 'fr',
                'title' => 'Nouveaux arrivants',
                'custom_slug' => 'newcomers',
                'redirection_page' => 'NewcomersListingPage',
            ],
        );
    }
}
