<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;

class UpdateParagraph extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $AllContentTypes = collect(InsideSchema::getContentTypes());

        $AllContentTypes->each(function ($contentType) use ($bridge) {
            if (InsideSchema::hasContentType($contentType) && InsideSchema::hasField($contentType, 'content')) {
                $bridge->updateFieldOptions(
                    type: $contentType,
                    fieldName: 'content',
                    options: [
                            'target_type' => [
                                "text",
                                "text_two_columns",
                                "text_with_image",
                                "file",
                                "image",
                                "video",
                                "accordion",
                                "call_to_action",
                                "button",
                                "html",
                                "tweet",
                                "fetched_contents",
                                "map",
                                "slider",
                            ]
                    ]
                );
            }
        });
    }
}
