<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class DeleteNewsSpacesField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('node', 'news', 'spaces');
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'news',
            fieldName: 'news_categories',
            options: [
                'name' => 'news_categories',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Catégorie(s) de l\'actualité',
                ],
                'description' => [
                    'fr' => 'Sélectionnez la ou les catégorie de cette actualité',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news_categories'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 5
        );
        $this->finishUp();
    }
}
