<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Blocks;
use Inside\Content\Models\Contents\Spaces;
use Inside\Content\Models\Contents\Applications;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Illuminate\Support\Facades\Artisan;

final class RestardizationOfToolsOnJobsSpaces extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $contentBridge = new BridgeContent();
        $contentTypeBridge = new BridgeContentType();

        Blocks::pluck('uuid')->each(fn (string $uuid) => $contentBridge->contentDelete('blocks', $uuid));

        $this->bootUp(__FILE__);
        $this->migrateContent('blocks', true);
        $this->finishUp();

        Artisan::call('models:rebuild');

        $contentTypeBridge->contentTypeCreateOrUpdateField(
            'spaces',
            'blocks',
            [
                'name' => 'blocks',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 7,
                'title' => [
                    'fr' => 'Bloc',
                ],
                'description' => [
                    'fr' => 'Choix des blocs dans lesquels l\'espace doit remonter',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['blocks'],
                    'cardinality' => -1,
                ],
            ],
        );

        Spaces::each(function ($space) use ($contentBridge) {
            $blocksWithSpacesRelation = [];

            $space->reverseApplications->each(function ($relationSpaceApplication) use ($contentBridge, &$blocksWithSpacesRelation) {
                $newBlockCheck = Blocks::where('title', $relationSpaceApplication->title)->value('uuid');

                if ($newBlockCheck) {
                    $blocksWithSpacesRelation[] = $newBlockCheck;
                } else {
                    $blocksWithSpacesRelation[] = $contentBridge->contentInsert('blocks', [
                        'title' => $relationSpaceApplication->title,
                        'background_color' => '#ffffff',
                        'image' => $relationSpaceApplication->image_app,
                        'icon' => json_encode(['name' => str($relationSpaceApplication->icon ?? 'sid2-empty')->after('sid2-')->toString()]),
                        'link' => $relationSpaceApplication->link,
                        'link_label' => $relationSpaceApplication->title,
                        'dark_mode' => false,
                    ]);
                }
            });

            $contentBridge->contentUpdate('spaces', [
                'uuid' => $space->uuid,
                'blocks' => $blocksWithSpacesRelation,
            ]);
        });

        Applications::whereDoesnthave('spaces')->each(fn ($applicationWithNoSpace) => $contentBridge->contentInsert('blocks', [
            'title' => $applicationWithNoSpace->title,
            'background_color' => '#ffffff',
            'image' => $applicationWithNoSpace->image_app,
            'icon' => json_encode(['name' => str($applicationWithNoSpace->icon ?? 'sid2-empty')->after('sid2-')->toString()]),
            'link' => $applicationWithNoSpace->link,
            'link_label' => $applicationWithNoSpace->title,
            'dark_mode' => false,
        ]));

        $contentTypeBridge->contentTypeDelete('applications');
    }
}
