<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\ShortcutsMenus;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Output\ConsoleOutput;

class GetShortcutsOutOfDrupal extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('tools');
        $this->migrateContent('users');

        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();
        $shortcuts = ShortcutsMenus::all();

        foreach ($shortcuts as $shortcut) {
            $uuid = null;
            $tool = Tools::query()
                ->where('title', $shortcut->title)
                ->where('link', $shortcut->link)
                ->where('langcode', $shortcut->langcode)
                ->first();

            if (empty($tool)) {
                $data = [
                    'bundle' => 'tools',
                    'link' => $shortcut->link,
                    'title' => $shortcut->title,
                    'image' => $shortcut->image,
                    'author' => $shortcut->author,
                    'type' => 'node',
                ];
                $uuid = $bridge->contentInsert('tools', $data);
            } else {
                $uuid = $tool->uuid;
            }

            $users = $shortcut->reverseUsers;

            $output = new ConsoleOutput();
            $bar = new ProgressBar($output, $users->count());
            $bar->setFormat("%message%\n %current%/%max% [%bar%] %percent:3s%%");
            $bar->setMessage("Converting " . $shortcut->title . " shortcut for " . $users->count() . " users");
            $bar->start();

            foreach ($users as $user) {
                $tools = $user->tools;
                if (!$tools) {
                    continue;
                }
                $tools = $tools->pluck('uuid')->toArray();
                if (!in_array($uuid, $tools)) {
                    $tools[] = $uuid;
                    $bridge->contentUpdate('users', [
                        'uuid' => $user->uuid,
                        'tools' => $tools
                    ]);
                }
                $bar->advance();
            }
        }
    }

    public function down(): void
    {
    }
}
