<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

/**
 * Class AddEndDateOnEvents
 */
class AddEndDateOnEvents extends Migration
{
    use HasConsole;

    /**
     * @var array
     */
    protected $endDateField = [
        'name' => 'end_date',
        'searchable' => false,
        'translatable' => false,
        'default' => null,
        'search_result_field' => true,
        'required' => false,
        'weight' => 2,
        'title' => [
            'fr' => 'Date de fin',
        ],
        'description' => [
            'fr' => '',
        ],
        'widget' => [
            'type' => BridgeContentType::TIMESTAMP_WIDGET,
            'settings' => [],
            'weight' => 2,
        ],
        'type' => BridgeContentType::TIMESTAMP_FIELD,
        'settings' => [
            'cardinality' => 1,
        ],
    ];

    public function up(): void
    {
        $this->write('Ajout du champ <fg=cyan>end_date</fg=cyan> au type de contenu <fg=magenta>Events</fg=magenta>');
        $bridge = new BridgeContentType();

        $this->writeResult($bridge->contentTypeCreateOrUpdateField('events', 'end_date', $this->endDateField));
    }
}
