<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Notify\Models\NotificationType;
use Inside\Content\Models\Contents\Users;

class CheckNotificationSubscriptions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        // Register default
        NotificationType::where('default', true)->each(function ($notificationType) {
            $notificationType->subscribers()->sync(Users::pluck('uuid'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
