<?php

use Illuminate\Database\Seeder;
use Inside\Permission\Models\Permission;
use Inside\Permission\Models\Role;

class FixSimplifiedPermissionSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->info('Seeding Simplified Permission fix');
        $this->command->line("");

        collect(
            [
                'webmaster',
            ]
        )->each(
            function ($name) {
                /** @var ?Role $role */
                $role = Role::where('name', $name)->first();
                if (!$role) {
                    return;
                }
                collect(
                    [
                        'Inside\Content\Models\Contents\Folders',
                    ]
                )->each(
                    function ($type) use ($role) {
                        Permission::firstOrCreate(
                            [
                                'role_id' => $role->id,
                                'action' => 'create',
                                'uuid' => null,
                                'type' => $type,
                            ]
                        );
                    }
                );
            }
        );
        $this->command->info('Permission fixed.');
    }
}
