<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Field;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Permission\Facades\Permission;
use Inside\Permission\Models\PermissionSchema;
use Inside\Permission\Models\Role;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Console\Output\ConsoleOutput;

class FixVisibilityList extends Migration
{
    protected array $layouts = [
        'groups'                                  => [
            'blocks' => '{"block-group-list-item-users-layouts-c6iqgvtib-0":{"parentID":"layouts-c6iqgvtib","module":{"module":"InsideUsers","display":"group-list-item"},"blockID":"block-group-list-item-users-layouts-c6iqgvtib-0","blockName":"group-list-item-users","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[],"blockFiltersDefault":{"sort":"created_at","limit":"100","offset":null,"order":"desc","paginate":0},"blockFields":[{"fieldType":"onoff","key":"count","value":null},{"fieldType":"onoff","key":"total_count","value":null},{"fieldType":"image","key":"image","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"reference","key":"members","target":["users"],"value":[{"key":"uuid","value":"1d4f5c59-46c8-44c1-b939-d63a2e206cf8","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":5,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"reference","key":"pending_members","target":["users"],"value":[{"key":"uuid","value":"1d4f5c59-46c8-44c1-b939-d63a2e206cf8","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":13,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"checkbox","key":"status","value":null},{"fieldType":"text","key":"title","value":null},{"fieldType":"onoff","key":"total","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"string","key":"uuid","value":null},{"fieldType":"list_string","key":"visibility","value":null},{"fieldType":"reference","key":"users","target":["users"],"value":[{"key":"uuid","value":"1d4f5c59-46c8-44c1-b939-d63a2e206cf8","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"langcode","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":4,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":14,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":true,"sort":null}},{"fieldType":"timestamp","key":"created_at","value":null}],"formattedContents":"groups","formattedFields":["count","total_count","image","admin",{"members":{"fields":["uuid","firstname","lastname","image"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},{"pending_members":{"fields":["uuid"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"status","title","total","content_type","slug","uuid","visibility",{"users":{"fields":["uuid","lastname","firstname","langcode","image"],"filters":{"limit":null,"offset":null,"reverse":true,"sort":"null:asc"}}},"created_at"],"formattedFilters":{"sort":"created_at:desc","limit":"100"}},"general":{"blockImageDisplay":"content","blockTitle":{"es":"","fr":"Groupes collaboratifs"},"blockSubtitle":{"es":"","fr":"<p>Chaque espace vous permet de communiquer au sein d\'un groupe restreints de collaborateurs.</p><p>N\'hésitez pas à nous demander la création d\'un espace privé ou public en nous précisant la thématique concernée.</p> <p>&nbsp;</p>"},"blockAlignment":"center","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":null,"parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null},"display":{"isView":true,"dataPath":null,"hasViewHeader":false,"filtersView":"","slideshowTitle":"","listView":"vertical","noResultLabelView":"","reversed":false,"hasViewButton":false,"urlViewButton":null,"labelViewButton":null},"filters":{"interfaceFilters":"[{\"type\":\"search\",\"model\":\"groups\",\"label\":\"search.searchGroup\"}]","hideMyEvents":false},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false}}',
            'layout' => '{"rows-0":{"id":"rows-0","layouts":{"layouts-c6iqgvtib":{"rows":{"rows-c6iqgvtib-0":{"id":"rows-c6iqgvtib-0","layouts":{},"layoutCounter":0}},"id":"layouts-c6iqgvtib","columns":1,"blocks":["block-group-list-item-users-layouts-c6iqgvtib-0"],"options":{"width":{"value":"765","unit":"px"},"maxWidth":{"value":"90","unit":"%"},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"45","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"}},"layoutCounter":1,"forms":[]}}',
            'option' => '{"allowedContents":["groups"]}',
        ],
        'inside_content_groups'                   => [
            'blocks' => '{"block-default-block-utils-layouts-5ttbnp6a2-0":{"parentID":"layouts-5ttbnp6a2","module":{"module":"InsideUtils","display":"default-block"},"blockID":"block-default-block-utils-layouts-5ttbnp6a2-0","blockName":"default-block-utils","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"groupe-prive","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0},"blockFields":[{"key":"users","isReversed":false,"index":0,"type":"field","value":[{"key":"count","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":4,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"fieldType":"reference","target":["users"],"filters":{"limit":null,"offset":null,"order":"asc","reverse":true,"sort":null}},{"key":"admin","isReversed":false,"index":1,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"title","isReversed":false,"index":2,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"members","isReversed":false,"index":3,"type":"field","value":[{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"count","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"fieldType":"reference","target":["users"],"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"visibility","isReversed":false,"index":4,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"uuid","isReversed":false,"index":5,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"slug","isReversed":false,"index":6,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","isReversed":false,"index":7,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"content_type","isReversed":false,"index":8,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"introduction","isReversed":false,"index":9,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"has_documents","isReversed":false,"index":10,"type":"field","value":null,"fieldType":"selectboolean","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups","formattedFields":[{"users":{"fields":["count","uuid","firstname","lastname","image"],"filters":{"limit":null,"offset":null,"reverse":true,"sort":"null:asc"}}},"admin","title",{"members":{"fields":["uuid","count"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"visibility","uuid","slug","image","content_type","introduction","has_documents"],"formattedFilters":{"slug:eq":"groupe-prive"},"normalizer":null},"general":{"blockImageDisplay":"banner","blockTitle":{"fr":"<i class=\"sid2-${\'`visibility`\' === \'private\' || \'`visibility`\' === \'restricted\' ? \'private\' : \'public\'}-group\"></i> Groupe \"${`title`}\""},"blockSubtitle":{"fr":"${`introduction`}"},"blockAlignment":"center","blockImage":"${`image`}","blockImageHeight":25,"blockClass":"","hasBlockImage":true,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":true},"block-full-comments-layouts-noaxvnuxf-0":{"parentID":"layouts-noaxvnuxf","module":{"module":"InsideComments","display":"full"},"blockID":"block-full-comments-layouts-noaxvnuxf-0","blockName":"full-comments","blockData":{},"blockOptions":{"content":{"contentTypes":["groups_posts"],"blockFilters":[{"key":"groups","value":[{"key":"slug","value":"groupe-public","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"filter"}],"index":0,"type":"filter","fieldType":"reference","target":["groups"],"operation":"eq"},{"key":"pid","value":"null","index":1,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":"created_at","limit":null,"offset":null,"order":"desc","paginate":0,"tree_sort":"created_at","tree_order":"asc"},"blockFields":[{"fieldType":"wysiwyg","key":"body","value":null},{"fieldType":"string","key":"uuid","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"onoff","key":"count","value":null},{"fieldType":"onoff","key":"total_count","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"onoff","key":"tree","value":null},{"fieldType":"string","key":"pid","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"reference","key":"reactions","target":["reactions"],"value":[{"key":"users","value":[{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"operation":"eq","fieldType":"reference","isReversed":false,"target":["users"],"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"count","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":9,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"timestamp","key":"created_at","value":null},{"fieldType":"file","key":"file","value":null},{"fieldType":"reference","key":"groups","target":["groups"],"value":[{"key":"uuid","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"title","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":13,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"list_string","key":"post_type","value":null},{"fieldType":"select","key":"langcode","value":null},{"fieldType":"checkbox","key":"status","value":null},{"fieldType":"text","key":"title","value":null},{"key":"authors","isReversed":false,"index":18,"type":"field","value":[{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"fieldType":"reference","target":["users"],"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups_posts","formattedFields":["body","uuid","slug","count","total_count","content_type","tree","pid","admin",{"reactions":{"fields":[{"users":{"fields":["uuid","firstname","image","lastname"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"count"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"created_at","file",{"groups":{"fields":["uuid","title"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"post_type","langcode","status","title",{"authors":{"fields":["uuid","lastname","firstname","image"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}}],"formattedFilters":{"groups":{"slug:eq":"groupe-restreint"},"pid:eq":null,"sort":"created_at:desc","tree_sort":"created_at:asc"},"normalizer":null},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-5ttbnp6a2-0","childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLabel":null,"printable":true},"display":{},"filters":{},"list":{},"custom":{"hasWallDisplay":true}},"blockPos":0,"isMainBlock":false},"block-group-users-layouts-3jmei006y-0":{"parentID":"layouts-3jmei006y","module":{"module":"InsideUsers","display":"group"},"blockID":"block-group-users-layouts-3jmei006y-0","blockName":"group-users","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"groupe-prive","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0},"blockFields":[{"fieldType":"reference","key":"users","target":["users"],"value":[{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":true,"sort":null}},{"fieldType":"reference","key":"members","target":["users"],"value":[{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"count","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups","formattedFields":[{"users":{"fields":["uuid","lastname","firstname","image"],"filters":{"limit":null,"offset":null,"reverse":true,"sort":"null:asc"}}},{"members":{"fields":["uuid","count"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}}],"formattedFilters":{"slug:eq":"groupe-prive"},"normalizer":null},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"${\'`parent:data.visibility`\' === \'restricted\' || \'`parent:data.visibility`\' === \'private\' ? \'Membres\' : \'Administrateurs\'} du groupe"},"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-5ttbnp6a2-0","childFilters":[],"hasGeneralLink":true,"urlGeneralLink":{"fr":"${parent:data.slug[0]}/membres"},"urlGeneralLinkHide":"${((\'`parent:data.visibility`\' === \'restricted\' || \'`parent:data.visibility`\' === \'private\') && `parent:data.users.count` <= 12) || (\'`parent:data.visibility`\' === \'public\' && `parent:data.members.count` <= 12)}","urlGeneralLabel":{"fr":"Voir tous les ${\'`parent:data.visibility`\' === \'restricted\' || \'`parent:data.visibility`\' === \'private\' ? \'Membres\' : \'Administrateurs\'} du groupe"},"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false},"block-back-to-parent-utils-layouts-6vmxwnhe5-0":{"parentID":"layouts-6vmxwnhe5","module":{"module":"InsideUtils","display":"back-to-parent"},"blockID":"block-back-to-parent-utils-layouts-6vmxwnhe5-0","blockName":"back-to-parent-utils","blockData":{},"blockOptions":{"content":{},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":true,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-5ttbnp6a2-0","childFilters":[],"hasGeneralLink":true,"urlGeneralLink":{"fr":"/groupes"},"urlGeneralLabel":{"fr":"Retour aux groupes"},"printable":true,"useDefaultLayout":false},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false},"block-basic-listing-layouts-7tg3rahic-0":{"parentID":"layouts-7tg3rahic","module":{"module":"InsideListing","display":"basic"},"blockID":"block-basic-listing-layouts-7tg3rahic-0","blockName":"basic-listing","blockData":{},"blockOptions":{"content":{"contentTypes":["groups_documents"],"blockFilters":[{"key":"groups","value":[{"key":"slug","value":"groupe-bca-test","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"filter"}],"index":0,"type":"filter","fieldType":"reference","target":["groups"],"operation":"eq"}],"blockFiltersDefault":{"sort":"created_at","limit":"4","offset":null,"order":"desc","paginate":0},"blockFields":[{"fieldType":"timestamp","key":"created_at","value":null},{"fieldType":"string","key":"uuid","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"onoff","key":"count","value":null},{"fieldType":"onoff","key":"total_count","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"onoff","key":"tree","value":null},{"fieldType":"string","key":"pid","value":null},{"fieldType":"section","key":"content","value":null},{"fieldType":"file","key":"file","value":null},{"fieldType":"checkbox","key":"status","value":null},{"fieldType":"text","key":"title","value":null},{"fieldType":"select","key":"langcode","value":null}],"formattedContents":"groups_documents","formattedFields":["created_at","uuid","slug","count","total_count","content_type","tree","pid","content","file","status","title","langcode"],"formattedFilters":{"groups":{"slug:eq":"groupe-restreint"},"sort":"created_at:desc","limit":"4"},"normalizer":null},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"Documents"},"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-5ttbnp6a2-0","childFilters":[],"hasGeneralLink":true,"urlGeneralLink":{"fr":"${parent:data.slug[0]}/documents"},"urlGeneralLinkHide":"${`parent:data.has_documents` === 0}","urlGeneralLabel":{"fr":"Voir tous les documents"},"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false},"block-group-notifications-layouts-8kx91xjkx-0":{"parentID":"layouts-8kx91xjkx","module":{"module":"InsideNotifications","display":"group"},"blockID":"block-group-notifications-layouts-8kx91xjkx-0","blockName":"group-notifications","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"groupe-prive","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0},"blockFields":[{"fieldType":"string","key":"uuid","value":null}],"formattedContents":"groups","formattedFields":["uuid"],"formattedFilters":{"slug:eq":"groupe-prive"}},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"Notifications"},"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":true,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-5ttbnp6a2-0","childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false},"block-group-btn-utils-layouts-3rk1udymn-0":{"parentID":"layouts-3rk1udymn","module":{"module":"InsideUtils","display":"group-btn"},"blockID":"block-group-btn-utils-layouts-3rk1udymn-0","blockName":"group-btn-utils","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"petite-groupe","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"string","key":"slug","value":null},{"fieldType":"string","key":"uuid","value":null},{"key":"has_documents","isReversed":false,"index":2,"type":"field","value":null,"fieldType":"selectboolean","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups","formattedFields":["slug","uuid","has_documents"],"formattedFilters":{"slug:eq":"petite-groupe"},"normalizer":null},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":true,"relativeBlock":null,"parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false}}',
            'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-6vmxwnhe5":{"rows":{"rows-6vmxwnhe5-0":{"id":"rows-6vmxwnhe5-0","layouts":{},"layoutCounter":0}},"id":"layouts-6vmxwnhe5","columns":1,"blocks":["block-back-to-parent-utils-layouts-6vmxwnhe5-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"0","right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-5ttbnp6a2":{"rows":{"rows-5ttbnp6a2-0":{"id":"rows-5ttbnp6a2-0","layouts":{},"layoutCounter":0}},"id":"layouts-5ttbnp6a2","columns":1,"blocks":["block-default-block-utils-layouts-5ttbnp6a2-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"0","right":0,"bottom":"45","left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-j3jalzy1k":{"rows":{"rows-j3jalzy1k-0":{"id":"rows-j3jalzy1k-0","layouts":{"layouts-3jmei006y":{"rows":{"rows-3jmei006y-0":{"id":"rows-3jmei006y-0","layouts":{},"layoutCounter":0}},"id":"layouts-3jmei006y","columns":1,"blocks":["block-group-users-layouts-3jmei006y-0"],"options":{"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"width":{},"maxWidth":{}}},"layouts-7tg3rahic":{"rows":{"rows-7tg3rahic-0":{"id":"rows-7tg3rahic-0","layouts":{},"layoutCounter":0}},"id":"layouts-7tg3rahic","columns":1,"blocks":["block-basic-listing-layouts-7tg3rahic-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"40","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-j3jalzy1k-0"},"layouts-3rk1udymn":{"rows":{"rows-3rk1udymn-0":{"id":"rows-3rk1udymn-0","layouts":{},"layoutCounter":0}},"id":"layouts-3rk1udymn","columns":1,"blocks":["block-group-btn-utils-layouts-3rk1udymn-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"40","right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-j3jalzy1k-0"},"layouts-8kx91xjkx":{"rows":{"rows-8kx91xjkx-0":{"id":"rows-8kx91xjkx-0","layouts":{},"layoutCounter":0}},"id":"layouts-8kx91xjkx","columns":1,"blocks":["block-group-notifications-layouts-8kx91xjkx-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"40","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-j3jalzy1k-0"}},"layoutCounter":4},"rows-j3jalzy1k-1":{"id":"rows-j3jalzy1k-1","layouts":{"layouts-noaxvnuxf":{"rows":{"rows-noaxvnuxf-0":{"id":"rows-noaxvnuxf-0","layouts":{},"layoutCounter":0}},"id":"layouts-noaxvnuxf","columns":1,"blocks":["block-full-comments-layouts-noaxvnuxf-0"],"options":{"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"width":{},"maxWidth":{}},"parentID":"rows-j3jalzy1k-1"}},"layoutCounter":1}},"id":"layouts-j3jalzy1k","columns":2,"blocks":[null],"options":{"width":{"value":"90","unit":"%"},"maxWidth":{"value":"1200","unit":"px"},"alignment":"left","colCount":2,"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}},"1":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":true,"layoutClass":"group","template":"sidebar"},"parentID":"rows-0"}},"layoutCounter":3}}',
            'option' => '{"allowedContents":["groups","groups_documents","groups_folders"]}',
        ],
        'inside_content_groups.subpage:membres'   => [
            'blocks' => '{"block-default-listing-layouts-tc6djxdfs-0":{"parentID":"layouts-tc6djxdfs","module":{"module":"InsideListing","display":"default"},"blockID":"block-default-listing-layouts-tc6djxdfs-0","blockName":"default-listing","blockData":{},"blockOptions":{"content":{"contentTypes":["users"],"blockFilters":[{"key":"groups","value":[{"key":"slug","value":"groupe-bca-test/membres","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"filter"}],"index":0,"type":"filter","fieldType":"reference","target":["groups"],"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0},"blockFields":[{"fieldType":"text","key":"uuid","target":null,"value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"firstname","isReversed":false,"index":1,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"lastname","isReversed":false,"index":2,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"image","isReversed":false,"index":3,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"content_type","isReversed":false,"index":4,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"services","isReversed":false,"index":5,"type":"field","value":[{"key":"uuid","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"title","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"fieldType":"reference","target":["services"],"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"phone","isReversed":false,"index":6,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"users","formattedFields":["uuid","firstname","lastname","image","content_type",{"services":{"fields":["uuid","title"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"phone"],"formattedFilters":{"groups":{"slug:eq":"petite-groupe/membres"}}},"general":{},"display":{},"filters":{},"list":{"modalName":"user","columnsList":"image,firstname,lastname,services,phone","noResultLabelList":"","isExportable":"","exportUrl":"","hideEdition":false,"allowGlobalExport":false,"exportExtension":"csv","exportFilename":"export","exportIcon":"export","defaultListView":"list"},"custom":{}},"blockPos":0,"isMainBlock":false},"block-default-block-utils-layouts-pfgwx4j5j-0":{"parentID":"layouts-pfgwx4j5j","module":{"module":"InsideUtils","display":"default-block"},"blockID":"block-default-block-utils-layouts-pfgwx4j5j-0","blockName":"default-block-utils","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"groupe-bca-test/membres","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0},"blockFields":[{"fieldType":"text","key":"title","target":null,"value":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"text","key":"uuid","target":null,"value":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"slug","isReversed":false,"index":2,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups","formattedFields":["title","uuid","slug"],"formattedFilters":{"slug:eq":"groupe-bca-test/membres"}},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"${\'`visibility`\' === \'restricted\' || \'`visibility`\' === \'private\' ? \'Membres\' : \'Administrateurs\'} du groupe \"${`title`}\""},"blockSubtitle":"","blockAlignment":"center","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":true},"block-back-to-parent-utils-layouts-dlzbnqo1d-0":{"parentID":"layouts-dlzbnqo1d","module":{"module":"InsideUtils","display":"back-to-parent"},"blockID":"block-back-to-parent-utils-layouts-dlzbnqo1d-0","blockName":"back-to-parent-utils","blockData":{},"blockOptions":{"content":{},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":true,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-pfgwx4j5j-0","childFilters":[],"hasGeneralLink":true,"urlGeneralLink":{"fr":"/${parent:data.slug[0]}"},"urlGeneralLabel":{"fr":"Retour au groupe \"${parent:data.title}\""},"printable":true,"useDefaultLayout":false},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false}}',
            'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-dlzbnqo1d":{"rows":{"rows-dlzbnqo1d-0":{"id":"rows-dlzbnqo1d-0","layouts":{},"layoutCounter":0}},"id":"layouts-dlzbnqo1d","columns":1,"blocks":["block-back-to-parent-utils-layouts-dlzbnqo1d-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"0","right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-pfgwx4j5j":{"rows":{"rows-pfgwx4j5j-0":{"id":"rows-pfgwx4j5j-0","layouts":{},"layoutCounter":0}},"id":"layouts-pfgwx4j5j","columns":1,"blocks":["block-default-block-utils-layouts-pfgwx4j5j-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"50","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-tc6djxdfs":{"rows":{"rows-tc6djxdfs-0":{"id":"rows-tc6djxdfs-0","layouts":{},"layoutCounter":0}},"id":"layouts-tc6djxdfs","columns":1,"blocks":["block-default-listing-layouts-tc6djxdfs-0"],"options":{"width":{"value":"90","unit":"%"},"maxWidth":{"value":"760","unit":"px"},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"25","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"}},"layoutCounter":3}}',
            'option' => '{"allowedContents":[]}',
        ],
        'inside_content_groups.subpage:documents' => [
            'blocks' => '{"block-full-ged-layouts-16zd8pxp5-0":{"parentID":"layouts-16zd8pxp5","module":{"module":"InsideGed","display":"full"},"blockID":"block-full-ged-layouts-16zd8pxp5-0","blockName":"full-ged","blockData":{},"blockOptions":{"content":{"contentTypes":["groups_folders"],"blockFilters":[{"key":"groups","value":[{"key":"slug","value":"groupe-prive/documents","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"filter"}],"index":0,"type":"filter","fieldType":"reference","target":["groups"],"operation":"eq"},{"key":"pid","value":"null","index":1,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":"1000","offset":null,"order":"asc","paginate":0},"blockFields":[{"fieldType":"timestamp","key":"created_at","value":null},{"fieldType":"string","key":"uuid","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"onoff","key":"count","value":null},{"fieldType":"onoff","key":"total_count","value":null},{"fieldType":"string","key":"content_type","value":null},{"fieldType":"string","key":"pid","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"reference","key":"reactions","target":["reactions"],"value":[{"key":"count","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"users","value":[{"key":"uuid","value":"ee5efdd9-8372-43a4-b899-9c7b661f2c11","operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"operation":"eq","fieldType":"reference","isReversed":false,"target":["users"],"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":8,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"reference","key":"groups","target":["groups"],"value":[{"key":"title","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"index":10,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"fieldType":"select","key":"langcode","value":null},{"fieldType":"checkbox","key":"status","value":null},{"fieldType":"text","key":"title","value":null},{"key":"groups_folders","isReversed":false,"index":13,"type":"field","value":[{"key":"title","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"slug","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"uuid","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"created_at","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"content_type","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":4,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"admin","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":5,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"fieldType":"reference","target":["groups_folders"],"filters":{"limit":null,"offset":null,"order":"asc","reverse":true,"sort":null}},{"key":"groups_documents","isReversed":false,"index":14,"type":"field","value":[{"key":"title","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":0,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"slug","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":1,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"uuid","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"created_at","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":3,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"content_type","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":4,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"file","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":5,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"admin","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":6,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}},{"key":"content","value":null,"operation":"eq","fieldType":"text","isReversed":false,"target":null,"index":7,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"fieldType":"reference","target":["groups_documents"],"filters":{"limit":null,"offset":null,"order":"desc","reverse":true,"sort":"created_at"}}],"formattedContents":"groups_folders","formattedFields":["created_at","uuid","slug","count","total_count","content_type","pid","admin",{"reactions":{"fields":["count",{"users":{"fields":["uuid"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}}],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},{"groups":{"fields":["title"],"filters":{"limit":null,"offset":null,"reverse":false,"sort":"null:asc"}}},"langcode","status","title",{"groups_folders":{"fields":["title","slug","uuid","created_at","content_type","admin"],"filters":{"limit":null,"offset":null,"reverse":true,"sort":"null:asc"}}},{"groups_documents":{"fields":["title","slug","uuid","created_at","content_type","file","admin","content"],"filters":{"limit":null,"offset":null,"reverse":true,"sort":"created_at:desc"}}}],"formattedFilters":{"groups":{"slug:eq":"petite-groupe/documents"},"pid:eq":null,"limit":"1000"},"normalizer":null},"general":{"blockImageDisplay":"content","blockTitle":{"fr":""},"blockSubtitle":"","blockAlignment":"center","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{"documentModel":"groups_documents","documentSort":"created_at:asc","folderModel":"groups_folders","hasImage":false,"hideSearchField":true,"disableToggleDisplay":false,"cardsDisplay":false,"isMinimal":false}},"blockPos":0,"isMainBlock":true},"block-default-block-utils-layouts-pwor160lq-0":{"parentID":"layouts-pwor160lq","module":{"module":"InsideUtils","display":"default-block"},"blockID":"block-default-block-utils-layouts-pwor160lq-0","blockName":"default-block-utils","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"groupe-bca-test/documents","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0},"blockFields":[{"fieldType":"string","key":"uuid","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"text","key":"title","target":null,"value":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups","formattedFields":["uuid","slug","title"],"formattedFilters":{"slug:eq":"groupe-bca-test/documents"}},"general":{"blockImageDisplay":"content","blockTitle":{"fr":"Documents du groupe \"${`title`}\""},"blockSubtitle":{"fr":"Retrouvez les documents du groupe"},"blockAlignment":"center","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":true},"block-back-to-parent-utils-layouts-iq4vukll3-0":{"parentID":"layouts-iq4vukll3","module":{"module":"InsideUtils","display":"back-to-parent"},"blockID":"block-back-to-parent-utils-layouts-iq4vukll3-0","blockName":"back-to-parent-utils","blockData":{},"blockOptions":{"content":{},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":true,"relativeBlock":"child","parentBlock":"block-default-block-utils-layouts-pwor160lq-0","childFilters":[],"hasGeneralLink":true,"urlGeneralLink":{"fr":"/${parent:data.slug[0]}"},"urlGeneralLabel":{"fr":"Retour au groupe \"${parent:data.title}\""},"printable":true,"useDefaultLayout":false},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":false},"block-group-btn-utils-layouts-uz0tu10kd-0":{"parentID":"layouts-uz0tu10kd","module":{"module":"InsideUtils","display":"group-btn"},"blockID":"block-group-btn-utils-layouts-uz0tu10kd-0","blockName":"group-btn-utils","blockData":{},"blockOptions":{"content":{"contentTypes":["groups"],"blockFilters":[{"key":"slug","value":"groupe-prive/documents","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"boolean","key":"has_documents","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"text","key":"uuid","target":null,"value":null,"index":2,"type":"field","filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"groups","formattedFields":["has_documents","slug","uuid"],"formattedFilters":{"slug:eq":"groupe-prive/documents"},"normalizer":null},"general":{},"display":{},"filters":{},"list":{},"custom":{"isGED":true}},"blockPos":0,"isMainBlock":false}}',
            'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-iq4vukll3":{"rows":{"rows-iq4vukll3-0":{"id":"rows-iq4vukll3-0","layouts":{},"layoutCounter":0}},"id":"layouts-iq4vukll3","columns":1,"blocks":["block-back-to-parent-utils-layouts-iq4vukll3-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"0","right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-pwor160lq":{"rows":{"rows-pwor160lq-0":{"id":"rows-pwor160lq-0","layouts":{},"layoutCounter":0}},"id":"layouts-pwor160lq","columns":1,"blocks":["block-default-block-utils-layouts-pwor160lq-0"],"options":{"width":{},"maxWidth":{},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"40","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-uz0tu10kd":{"rows":{"rows-uz0tu10kd-0":{"id":"rows-uz0tu10kd-0","layouts":{},"layoutCounter":0}},"id":"layouts-uz0tu10kd","columns":1,"blocks":["block-group-btn-utils-layouts-uz0tu10kd-0"],"options":{"width":{"value":"90","unit":"%"},"maxWidth":{"value":"1160","unit":"px"},"alignment":"center","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"bgColor":"none","settingsProperty":"","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"},"layouts-16zd8pxp5":{"rows":{"rows-16zd8pxp5-0":{"id":"rows-16zd8pxp5-0","layouts":{},"layoutCounter":0}},"id":"layouts-16zd8pxp5","columns":1,"blocks":["block-full-ged-layouts-16zd8pxp5-0"],"options":{"width":{"value":"90","unit":"%"},"maxWidth":{"value":"1160","unit":"px"},"alignment":"left","colCount":1,"colOptions":{"0":{"width":{"value":null,"unit":"px"},"margins":{"top":"50","right":0,"bottom":0,"left":0}}},"bgColor":"none","noBlock":false,"layoutClass":"","template":"none"},"parentID":"rows-0"}},"layoutCounter":4}}',
            'option' => '{"allowedContents":["groups_documents","groups_folders"]}',
        ],
    ];

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        // Prepare a console
        $output      = new ConsoleOutput();
        $outputStyle = new OutputFormatterStyle('white', 'green', ['bold', 'blink', 'underscore']);
        $output->getFormatter()->setStyle('module', $outputStyle);
        $outputStyle = new OutputFormatterStyle('yellow', 'default', ['bold', 'blink', 'underscore']);
        $output->getFormatter()->setStyle('class', $outputStyle);

        $output->writeln("<info>Début de l'installation du module</info> <module>inside-groups</module>");

        $bridge = new BridgeContentType();

        $groups = include __DIR__ . '/contents/groups.php';

        try {
            $output->writeln("<info>Création du type de contenu</info> <class> Groups </class>");
            $bridge->contentTypeUpdateOrCreate(
                $groups['options']['name'],
                $groups['options'],
                $groups['fields']
            );
            $output->writeln("<class> Groups </class> <comment>correctement créé</comment> ");
        } catch (Exception $e) {
            dd($e);
        }

        $groups_posts = include __DIR__ . '/contents/groups_posts.php';

        try {
            $output->writeln("<info>Création du type de contenu</info> <class> GroupsPosts </class>");
            $bridge->contentTypeUpdateOrCreate(
                $groups_posts['options']['name'],
                $groups_posts['options'],
                $groups_posts['fields']
            );
            $output->writeln("<class> GroupsPosts </class> <comment>correctement créé</comment> ");
        } catch (Exception $e) {
            dd($e);
        }

        $groups_folders = include __DIR__ . '/contents/groups_folders.php';

        try {
            $output->writeln("<info>Création du type de contenu</info> <class> GroupsFolders </class>");
            $bridge->contentTypeUpdateOrCreate(
                $groups_folders['options']['name'],
                $groups_folders['options'],
                $groups_folders['fields']
            );
            $output->writeln("<class> GroupsFolders </class> <comment>correctement créé</comment> ");
        } catch (Exception $e) {
            dd($e);
        }

        $groups_documents = include __DIR__ . '/contents/groups_documents.php';

        try {
            $output->writeln("<info>Création du type de contenu</info> <class> GroupsDocuments </class>");
            $bridge->contentTypeUpdateOrCreate(
                $groups_documents['options']['name'],
                $groups_documents['options'],
                $groups_documents['fields']
            );
            $output->writeln("<class> GroupsDocuments </class> <comment>correctement créé</comment> ");
        } catch (Exception $e) {
            dd($e);
        }

        // Add groups field to users
        $users_groups = include __DIR__ . '/fields/users/groups.php';

        try {
            $output->writeln(
                "<info>Ajout d'un champ</info> <class>groupes</class> dans les informations de l'utilisateur"
            );
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'groups',
                $users_groups
            );
            $output->writeln("<comment> Champ <class>groupes</class> correctement créé</comment> ");
        } catch (Exception $e) {
            dd($e);
        }

        // Tricks on groups field ( We want belongsTo but inside can't do it yet )
        $output->writeln("<info>On force les champs <class>groupes</class> a être en sélection unique</info>");
        /** @var Collection<Field> $fields */
        $fields = Field::where('name', 'groups')->orWhere('name', 'groups_folders')->get();
        foreach ($fields as $field) {
            $options = $field->options;
            if (data_get($options, 'cardinality') == -1) {
                $options['cardinality'] = 1;
                $field->options         = $options;
                $field->save();
            }
        }
        $output->writeln("<comment>Champ <class>groupes</class> maintenant en sélection unique</comment>");

        // Be sur to have models
        $output->writeln("<info>Nettoyage du cache et reconstruction des classes dynamiques.</info>");
        Artisan::call('cache:clear');
        Artisan::call('models:rebuild');
        $output->writeln("<comment>Fait</comment>");

        // Notifications Types
        $groups = type_to_class('groups')::all();


        // Un utilisateur vient d'être ajouté à un groupe
        $notificationTypes[] = $this->prepareNotificationTypes(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Groups\Events\UserJoinedAGroupEvent',
                'model'     => type_to_class('groups'),
                'action'    => 'custom',
                'type'      => 'group',
                'condition' => '',
                'multiple'  => true,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'title'       => 'notifications.group.invited.title',
                'description' => 'notifications.group.invited.description',
                'icon'        => 'group',
                'text'        => 'notifications.group.invited.text',
                'fields'      => ['title', 'slug'],
            ],
            $output
        );
        $notificationTypes[] = $this->prepareNotificationTypes(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Groups\Events\UserJoinedAGroupEvent',
                'model'     => type_to_class('groups'),
                'action'    => 'custom',
                'type'      => 'group',
                'condition' => '',
                'multiple'  => true,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'title'       => 'notifications.group.invited.mail.title',
                'description' => 'notifications.group.invited.mail.description',
                'mail'        => [
                    'subject'    => 'notifications.group.invited.mail.subject',
                    'text'       => 'notifications.group.invited.mail.content',
                    'buttonText' => 'notifications.group.invited.mail.buttonText',
                ],
            ],
            $output
        );

        // Un utilisateur à demander à rejoindre un groupe restreint
        $notificationTypes[] = $this->prepareNotificationTypes(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Groups\Events\UserAskedToJoinAGroupEvent',
                'model'     => type_to_class('groups'),
                'action'    => 'custom',
                'type'      => 'group',
                'condition' => '',
                'multiple'  => true,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'title'       => 'notifications.group.member.pending.title',
                'description' => 'notifications.group.member.pending.description',
                'icon'        => 'group',
                'text'        => 'notifications.group.member.pending.text',
                'fields'      => ['title', 'slug'],
                'url'         => 'EDIT',
            ],
            $output
        );
        $notificationTypes[] = $this->prepareNotificationTypes(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Groups\Events\UserAskedToJoinAGroupEvent',
                'model'     => type_to_class('groups'),
                'action'    => 'custom',
                'type'      => 'group',
                'condition' => '',
                'multiple'  => true,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'title'       => 'notifications.group.member.pending.mail.title',
                'description' => 'notifications.group.member.pending.mail.description',
                'mail'        => [
                    'subject'    => 'notifications.group.member.pending.mail.subject',
                    'text'       => 'notifications.group.member.pending.mail.content',
                    'buttonText' => 'notifications.group.member.pending.mail.buttonText',
                ],
            ],
            $output
        );
        // Un utilisateur a aimé un post
        $notificationTypes[] = $this->prepareNotificationTypes(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => ReactionSubscribedEvent::class,
                'model'     => type_to_class('groups_posts'),
                'action'    => 'like',
                'type'      => 'group',
                'condition' => 'author:CURRENT_USER',
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'title'       => 'notifications.group.like.groups_posts.title',
                'description' => 'notifications.group.like.groups_posts.description',
                'icon'        => 'group',
                'text'        => 'notifications.group.like.groups_posts.text',
                'fields'      => ['title', 'groups' => ['title'], 'authors' => ['firstname', 'lastname']],
                'url'         => 'ROOT_RELATION:groups',
            ],
            $output
        );

        $output->writeln("<info>Inscription des utilisateurs existants aux nouvelles notifications</info>");
        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid'            => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
        }
        $output->writeln("<comment>Fait</comment>");

        // Fix default notification Type !

        // Like something
        $output->writeln(
            "<info>Correction des notifications like qui s'appliquaient à tous les types de contenus</info>"
        );
        $notificationTypes = NotificationType::where('action', 'like')->where('model', '')->orWhereNull('model')->get();
        foreach ($notificationTypes as $notificationType) {
            $notificationType->model = 'Inside\Content\Models\Contents\News';
            $notificationType->save();
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid'            => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
        }
        $output->writeln("<comment>Fait</comment>");

        // Rebuild
        $output->writeln("<info>Reconstruction de l'index de recherche</info>");
        Artisan::call('index:rebuild', ['--silent' => true]);
        $output->writeln("<comment>Fait</comment>");

        // Clean old permission
        $output->writeln("<info>Suppression des schema de permission</info>");
        PermissionSchema::where('authorizable_type', type_to_class('groupes'))->delete();
        PermissionSchema::where('authorizable_type', type_to_class('groups_posts'))->delete();
        PermissionSchema::where('authorizable_type', type_to_class('groups_folders'))->delete();
        PermissionSchema::where('authorizable_type', type_to_class('groups_documents'))->delete();
        $output->writeln("<comment>Fait</comment>");

        // Clean authenticated
        $output->writeln("<info>Reconstruction des permissions pour le role auhenticated</info>");
        /** @var Role $authenticated */
        $authenticated = Role::where('name', 'authenticated')->first();
        Permission::buildPermissionForRole($authenticated->id);
        $output->writeln("<comment>Fait</comment>");

        $output->writeln("<info>Reconstruction des permissions des groupes existants</info>");
        type_to_class('groups')::each(
            function ($group) {
                $group->touch(); // Rebuild permission for this group
            }
        );
        $output->writeln("<comment>Fait</comment>");
    }

    protected function prepareNotificationTypes(array $info, array $data, ConsoleOutput $output): NotificationType
    {
        $output->writeln(
            "<info>Prépartion de la type de notification via:{$info['via']} type:{$info['type']} event:{$info['event']} model:{$info['model']} condition:{$info['condition']}</info>"
        );
        /** @var ?NotificationType $notificationType */
        $notificationType = NotificationType::where($info)->first();
        if ($notificationType) {
            $notificationType->data = $data;
            $notificationType->save();
        } else {
            $info['data']     = $data;
            /** @var NotificationType $notificationType */
            $notificationType = NotificationType::create($info);
        }
        Artisan::call('cache:clear');
        Artisan::call('models:rebuild');
        $output->writeln("<comment>Fait</comment>");

        return $notificationType;
    }
}
