<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class AddBirthdayField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'birthday',
            options: [
            'name' => 'birthday',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'editable' => false,
            'title' => [
                'fr' => 'Anniversaire',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => null,
        ]
        );

        Artisan::call("models:rebuild");
    }
}
