<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => false,
        'categorizable'     => false,
        'name'              => 'newsletters',
        'title'             => [
            'fr' => 'Newsletters',
        ],
    ],
    'fields'  => [
        [
            'name'                => 'body',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => '',
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Introduction',
            ],
            'description'         => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows'         => 9,
                    'summary_rows' => 3,
                    'placeholder'  => '',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'news',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Actualités',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => 2,
                'group'    => 'group_options',
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['news'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'events',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Événements',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => 3,
                'group'    => 'group_options',
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['events'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'documents',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'title'               => [
                'fr' => 'Documents',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => 4,
                'group'    => 'group_options',
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['documents'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'newsletter_roles',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Rôles destinataires',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 5,
                'hidden'   => true,
                'group'    => 'group_advanced_options',
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
    ],
];
