import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesListing from '../pages/spaces/SpacePagesListing'
import {
  fetchSpacePage,
  fetchSpacePagesListing
} from '../components/spaces/space'

import ProjectPage from '../pages/projects/ProjectPage'
import { fetchProject } from '../components/projects/projects'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false, content: 'news' },
    props: {
      extraFields: [{ subsidiaries: ['uuid', 'title'] }],
      contentOptions: {
        categoriesConfig: {
          subsidiaries: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            href: data => ({
              name: 'NewsListingPage',
              query: { subsidiaries: data.uuid }
            })
          },
          news_categories: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            href: data => ({
              name: 'NewsListingPage',
              query: { news_categories: data.uuid }
            })
          }
        }
      }
    }
  },
  {
    name: 'ProjectNewsListingPage',
    path: {
      fr: '/actualites-des-filiales',
      en: '/subsidiaries-news'
    },
    component: () => import('../pages/ProjectNewsListingPage')
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    component: () => import('../pages/events/EventsCalendarPage')
  },
  {
    name: 'EventPage',
    meta: { disabled: false, content: 'events' },
    component: () => import('../pages/events/EventPage')
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'NewcomersListingPage',
    props: {
      bannerData: {
        add: ['movements_categories', 'movements']
      }
    }
  },
  {
    name: 'SpacePage',
    path: {
      fr: '/espaces/:slug',
      en: '/spaces/:slug'
    },
    meta: { content: 'spaces' },
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    name: 'SpacePagesListing',
    path: {
      fr: '/espaces/pages/:slug',
      en: '/spaces/pages/:slug'
    },
    alias: ['/fr/espaces/:slug/pages', '/en/spaces/:slug/pages'],
    meta: { content: 'spaces' },
    component: withFetch(SpacePagesListing, { size: 'xxl', watch: true })(
      fetchSpacePagesListing
    )
  },
  {
    name: 'CarpoolingPage',
    path: {
      fr: '/covoiturage',
      en: '/carpooling'
    },
    component: () => import('../pages/CarpoolingPage')
  },
  {
    name: 'ProjectsListingPage',
    path: {
      fr: '/projets',
      en: '/projects'
    },
    component: () => import('../pages/projects/ProjectsListingPage')
  },
  {
    name: 'ProjectPage',
    path: {
      fr: '/projets/:slug',
      en: '/projects/:slug'
    },
    meta: { content: 'projects' },
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    )
  },
  {
    name: 'SubsidiariesNewsListingPage',
    path: {
      fr: '/actualités-des-filiales',
      en: '/subsidiaries-news'
    },
    component: () => import('../pages/SubsidiariesListingPage')
  },
  {
    name: 'WallPage',
    props: {
      useSubscription: false
    },
    meta: { disabled: false, content: 'walls' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FullWidthPage',
    meta: { disabled: false, content: 'full_width_pages' }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsAutomaticTranslationPage',
    meta: { admin: true, display: true }
  }
]
