import { getContentImage } from '@inside-library/helpers/Image'
import { videoExtensionsList } from './constants'

export default {
  'inside-comments': {
    mentionsEnabled: true,
    walls: {
      attachments: {
        deniedExtensions: videoExtensionsList
      }
    }
  },
  'inside-edition': {
    liveTranslateEdition: {
      enabled: true
    }
  },
  'inside-ged': {
    rootRoute: {
      fr: 'mediatheque',
      en: 'library'
    },
    paragraphs: {
      fetchedContents: {
        listingAttributes: { itemsPerPage: 24 }
      }
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    showBookmarks: false,
    paragraphs: {
      fetchedContents: {
        listingAttributes: { itemsPerPage: 24 },
        display: () => import('./components/news/MinimalNews'),
        displayAttributes: ({ item }) => ({
          to: {
            name: 'NewsPage',
            params: { slug: item.slug[0] }
          }
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'title',
            'chapo',
            'slug',
            'image',
            'published_at',
            {
              news_categories: ['uuid', 'title']
            },
            {
              subsidiaries: ['uuid', 'title']
            },
            'content_type'
          ],
          filters: {
            'status:eq': 1
          },
          valueCallback: item => item.uuid_host,
          labelCallback: item => item.title
        },
        requestFields: [
          'uuid',
          'title',
          'chapo',
          'slug',
          'image',
          'published_at',
          {
            news_categories: ['uuid', 'title']
          },
          {
            subsidiaries: ['uuid', 'title']
          },
          'content_type'
        ]
      }
    },
    templates: {
      fullContent: {
        relatedComponent: () => import('./components/news/MinimalNews'),
        relatedFields: () => [
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          },
          {
            subsidiaries: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    }
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    shortcuts: {
      max: 5
    },
    paragraphs: {
      fetchedContents: {
        listingAttributes: { itemsPerPage: 24 },
        display: () => import('./components/users/CardUser'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'mobile_phone',
          'phone',
          'image',
          'function'
        ]
      }
    }
  },
  'inside-tools': {
    paragraphs: {
      fetchedContents: {
        listingAttributes: { itemsPerPage: 24 }
      }
    }
  },
  'inside-events': {
    paragraphs: {
      fetchedContents: {
        listingAttributes: { itemsPerPage: 24 }
      }
    }
  }
}
