export const spacePagesCategoriesFilters = {
  'status:eq': 1,
  sort: 'weight:asc'
}

export const spacePagesFilters = {
  'status:eq': 1,
  sort: 'weight:asc'
}

export const projectModalFields = [
  'title',
  {
    building_types: ['uuid', 'title']
  },
  {
    subsidiaries: ['uuid', 'title']
  },
  'issues',
  'our_answer',
  {
    building_function: ['uuid', 'title']
  },
  'technical_description',
  {
    industries: ['uuid', 'title']
  },
  'address',
  {
    professions: ['uuid', 'title']
  },
  {
    cities: ['uuid', 'title']
  },
  {
    departments: ['uuid', 'title']
  },
  'country',
  'accesses',
  'communicable_reference',
  'planner',
  'construction_start_quarter',
  {
    marketing_statuses: ['uuid', 'title']
  },
  'project_amount',
  'built_area',
  'number_of_lots',
  'available_area',
  'land_area',
  'commercial_area',
  'building_floor_area',
  {
    energy_approaches: ['uuid', 'title']
  },
  'customer_testimonial',
  'our_answer',
  {
    project_types_ing: ['uuid', 'title']
  },
  {
    project_types_fp: ['uuid', 'title']
  },
  {
    progress_projects: ['uuid', 'title']
  },
  {
    commercial_firms: [
      'content_type',
      'uuid',
      'title',
      'address',
      'zipcode',
      'contact',
      'email',
      'opening_time',
      'phone_mentions',
      'phone',
      { cities: ['uuid', 'title'] }
    ]
  },
  'user',
  'leasing_user',
  'investor',
  'co_promoter',
  'architect',
  'builder',
  { construction_quarters: ['uuid', 'title'] },
  'construction_year',
  { delivery_date_quarters: ['uuid', 'title'] },
  'delivery_year',
  'leasing_date',
  'leasing_duration',
  'work_duration',
  'benefits',
  'benefits_and_user_comfort',
  'distance_and_round_time',
  'divisible',
  'divisible_from',
  'number_of_created_jobs',
  'geographic_location',
  'hook',
  {
    tax_benefits: ['uuid', 'title']
  },
  {
    pinel_areas: ['uuid', 'title']
  },
  {
    ptz_areas: ['uuid', 'title']
  },
  {
    certificates: ['uuid', 'title']
  }
]

export const projectPageFields = [
  'title',
  'uuid',
  'published_at',
  'admin',
  'content_type',
  'banner',
  'content',
  'slug',
  'delivery_date',
  'geographic_location',
  'project_description',
  'content',
  'latitude',
  'longitude',
  'main_image',
  'address',
  {
    projects: ['uuid', 'title', 'slug', 'main_image']
  },
  {
    project_teams: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'function',
      'phone',
      'mobile_phone'
    ]
  },
  {
    projects_statuses: ['uuid', 'title', 'color']
  },
  {
    subsidiaries: ['uuid', 'title']
  },
  {
    news: {
      fields: [
        'uuid',
        'title',
        'content_type',
        'slug',
        'published_at',
        'image',
        { subsidiaries: ['uuid', 'title'] }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc'
      }
    }
  },
  {
    project_news: {
      fields: [
        'uuid',
        'title',
        'content_type',
        'slug',
        'uri',
        'published_at',
        'image_link',
        { subsidiaries: ['uuid', 'title'] }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc'
      }
    }
  },
  {
    industries: ['uuid', 'title']
  },
  {
    building_types: ['uuid', 'title']
  },
  {
    cities: ['uuid', 'title']
  },
  {
    project_folders: {
      fields: ['uuid', 'title', 'content_type', 'published_at'],
      filters: {
        reverse: true,
        'status:eq': 1,
        sort: 'published_at:desc'
      }
    }
  }
]

export const videoExtensionsList =
  '.3gp, .3g2, .h261, .h263, .h264, heic, heif, .jpm, .mj2, .mjp2, .mp4, .mp4v, .mpg4, .m1v, .m2v, .mpa, .mpe, .mpeg, .mpg, .ogv, .mov, .qt, .fvt, .m4u, .mxu, .pyv, .viv, .webm, .f4v, .fli, .flv, .m4v, .mkv, .asf, .asx, .wm, .wmv, .wmx, .wvx, .avi, .movie'
