import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: ['uuid'] }],
    add: async ({ data: { uuid } }) => {
      try {
        const { data } = await http.get('content/spaces_pages', {
          fields: [{ pages_categories: [{ spaces: ['slug'] }] }],
          filters: { 'uuid:eq': uuid }
        })

        const slug = data[0]?.pages_categories?.spaces?.slug?.[0]

        return {
          name: 'SpacePagesListing',
          params: { slug },
          query: { page: uuid }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/spaces_pages', {
          fields: [
            {
              pages_categories: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidSpacePage = data[0].pages_categories.uuid

        data = await http.get('content/pages_categories', {
          fields: [
            {
              spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidSpacePage }
        })

        const slug =
          get(data, ['data', 0, 'spaces', 'slug', 0]) ||
          get(data, ['data', 0, 'spaces', 'data', 0, 'slug', 0])

        return {
          name: 'SpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  carpools: {
    add: () => ({
      name: 'CarpoolingPage'
    }),
    delete: () => ({
      name: 'CarpoolingPage'
    })
  },
  moveHours: {
    add: () => ({
      name: 'CarpoolingPage'
    }),
    delete: () => ({
      name: 'CarpoolingPage'
    })
  },
  cities: {
    add: () => ({
      name: 'CarpoolingPage'
    }),
    delete: () => ({
      name: 'CarpoolingPage'
    })
  },
  projectsStatuses: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsLocations: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  deliveryYears: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  energyApproaches: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  taxBenefits: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  certificates: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  departments: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectTeams: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  professions: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsTypes: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  regions: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  industries: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  marketingStatuses: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  buildingTypes: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  pinelAreas: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  ptzAreas: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectFolders: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/projects', {
          fields: ['uuid', 'title', 'slug'],
          filters: { 'status:eq': 1, 'uuid:eq': fields.projects[0] }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: data[0].slug[0]
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/project_folders', {
          fields: ['uuid', { projects: ['uuid', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: data[0].projects.data[0].slug[0]
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  projectDocuments: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/project_folders', {
          fields: ['uuid', { projects: ['uuid', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': fields.project_folders }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: data[0].projects.data[0].slug[0]
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: folderUuid } = await http.get(
          'content/project_documents',
          {
            fields: ['uuid', { project_folders: ['uuid'] }],
            filters: { 'status:eq': 1, 'uuid:eq': uuid }
          }
        )

        const { data } = await http.get('content/project_folders', {
          fields: ['uuid', { projects: ['uuid', 'slug'] }],
          filters: {
            'status:eq': 1,
            'uuid:eq': folderUuid[0].project_folders.uuid
          }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: data[0].projects.data[0].slug[0]
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  projectNews: {
    globalSearch: ({ data }) => ({
      action: () => {
        window.open(data.uri, '_blank')
      }
    })
  }
}
