import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import ProjectItemCustoms from '../components/projects/ProjectItemCustoms'
import CarpoolModal from '../components/carpooling/CarpoolModal'
import ProjectCharacteristicsModal from '../components/projects/ProjectCharacteristicsModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('project-item-customs', ProjectItemCustoms)
    app.component('carpool-modal', CarpoolModal)
    app.component('project-characteristics-modal', ProjectCharacteristicsModal)
  })
}
