import { http } from '@inside-library/helpers/Http'
import { projectPageFields } from '../../constants'
import { getStatusFilters } from '@inside-library/helpers/Permissions'

export const fetchProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: projectPageFields,
      filters: {
        'slug:eq': $route.params.slug,
        ...getStatusFilters('projects')
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
