import { http } from '@inside-library/helpers/Http'

import moment from 'moment'
const fetchProjectNews = async () => {
  try {
    const { data } = await http.get('content/project_news', {
      fields: [
        'uuid',
        'title',
        'project_mews_content',
        'published_at',
        'chapo',
        'image_link',
        'uri',
        { subsidiaries: ['uuid', 'title', 'slug'] }
      ],
      filters: {
        limit: 3,
        'status:eq': 1,
        sort: 'published_at:desc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchNewcomers = async () => {
  try {
    const { data } = await http.get('content/movements', {
      fields: [
        'uuid',
        'content_type',
        'published_at',
        {
          movements_users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone',
              'mobile_phone',
              { subsidiaries: ['uuid', 'title'] },
              'content_type'
            ],
            filters: { alias: 'users' }
          }
        },
        { movements_categories: ['uuid', 'title', 'template'] },
        { reactions: [{ users: ['uuid'] }] }
      ],
      filters: {
        limit: 2,
        'published_at:lte': 'now()',
        sort: 'published_at:desc',
        'status:eq': 1
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchNewsListing = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        { news_categories: ['uuid', 'title', 'content_type'] },
        { subsidiaries: ['uuid', 'title', 'content_type'] },
        { reactions: ['count', { users: ['uuid'] }] },
        { comments: ['count'] }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        'is_featured:eq': 1,
        limit: 2
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjects = async () => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'title',
        'uuid',
        'published_at',
        'admin',
        'content_type',
        'content',
        'slug',
        'main_image',
        {
          cities: ['uuid', 'title']
        },
        {
          subsidiaries: ['uuid', 'title']
        }
      ],
      filters: {
        'status:eq': 1,
        'published_at:lte': 'now()',
        sort: 'published_at:desc',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchProjectNews, fetchNewcomers, fetchNewsListing, fetchProjects }
