import { projectModalFields } from '../inside-customs/constants'

export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'function',
      'linkedin',
      'twitter',
      'teams',
      'email',
      'phone',
      'mobile_phone',
      { subsidiaries: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      'languages',
      'skills',
      'office_location',
      'address',
      { cities: ['uuid', 'title'] },
      { users: ['uuid', 'firstname', 'lastname', 'function', 'phone', 'image'] }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  carpools: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'published_at',
      'introduction',
      { move_hours: ['title', 'uuid'] },
      { arrival_cities: ['title', 'uuid'] },
      { departure_cities: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname', 'image'] }
    ]
  },
  projects: {
    modalFields: projectModalFields
  },
  project_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { project_folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
