<?php

use Illuminate\Support\Facades\Route;
use Inside\IIDE\Http\Controllers\ProjectToPDFController;
use Inside\Content\Http\Controllers\External\Index as ExternalIndex;

Route::group(
    [
        'middleware' => ['auth'],
    ],
    function ($router) {
        $router->get('/pdf-download/projects/{uuid}', [
            'as' => 'project-to-pdf-download',
            'uses' => ProjectToPDFController::class
        ]);
    }
);

Route::group(
    [
        'namespace' => 'Inside\IIDE\Http\Controllers',
        'prefix' => 'api/v1/external',
        'middleware' => ['auth.external:faubourg-immobilier,faubourg-promotion']
    ],
    function ($router) {
        $router->get('/projects/{uuid}', ['uses' => 'ProjectApiController@project']);
        $router->get('/resource/{path:.*}', ['uses' => 'ProjectApiController@resource']);
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:faubourg-immobilier,faubourg-promotion']
    ],
    function ($router) {
        $router->get('external/{type:'.get_authorized_external_api_content_types().'}', ExternalIndex::class);
    }
);
