<?php

namespace Inside\IIDE\Http\Controllers;

use Illuminate\Http\Response;
use Inside\IIDE\Services\ProjectToPDFService;
use Laravel\Lumen\Routing\Controller;

class ProjectToPDFController extends Controller
{
    public function __invoke(string $uuid): Response
    {
        $pdf = ProjectToPDFService::load($uuid, 'pdf.export-project');

        if (!$pdf) {
            abort(404);
        }

        /** @phpstan-ignore-next-line  */
        return $pdf->download();
    }
}
