<?php

namespace Inside\IIDE\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Laravel\Lumen\Routing\Controller;
use Inside\Content\Models\Contents\Projects;
use Inside\Permission\Facades\Permission;
use Inside\Content\Transformers\ContentTransformer;
use Symfony\Component\HttpFoundation\Response;

class ProjectApiController extends Controller
{
    public function project(Request $request, string $uuid): JsonResponse
    {
        $projectDetails = Permission::withoutAllowedScope(function () use ($uuid, $request) {
            $langcode = $request->has('langcode') ? $request->get('langcode') : env('APP_LOCALE');
            $project = Projects::where('langcode', $langcode)->findOrFail($uuid);
            $transformer = new ContentTransformer();

            $attributes = [
                'langcode',
                'project_id',
                'title',
                'project_description',
                'subsidiaries' => ['title', 'logo'],
                'industries' => ['title'],
                'building_types' => ['title'],
                'address', 'cities' => ['title'],
                'departments' => ['title'],
                'country',
                'latitude',
                'longitude',
                'communicable_reference',
                'work_duration',
                'main_image',
                'content',
                'architect',
                'project_amount',
                'built_area',
                'project_types_ing' => ['title'],
                'issues',
                'our_answer',
                'certificates' => ['title'],
                'investor',
                'projects_statuses' => ['title'],
                'benefits_and_user_comfort',
                'technical_description',
                'marketing_statuses',
                'available_area',
                'land_area',
                'number_of_created_jobs',
                'leasing_user',
                'leasing_date',
                'leasing_duration',
                'lease',
                'divisible',
                'progress_projects' => ['title'],
                'commercial_area',
                'content' => ['uuid']];
            $data = [];
            $transformer->transform($project, $attributes, $data);
            return $data;
        });

        return new JsonResponse(['data'  => $projectDetails]);
    }

    public function resource(Request $request, string $path): Response | JsonResponse
    {
        $exploadedPath = explode('/', $path);
        $filePath = implode('/', array_slice($exploadedPath, -2, 2));
        if (!Storage::exists($filePath)) {
            return new JsonResponse(['message' => 'File not found !'], 404);
        }
        $path = Storage::path($filePath);

        /** @var string $img */
        $img = file_get_contents($path);
        /** @var array $pathinfo */
        $pathinfo = pathinfo($path);
        $extension = $pathinfo['extension'];
        switch ($extension) {
            case "gif":
                $type = "image/gif";
                break;
            case "png":
                $type = "image/png";
                break;
            case "jpeg":
            case "jpg":
                $type = "image/jpeg";
                break;
            case "mp4":
                $type = "video/mp4";
                break;
            default:
                return new JsonResponse(['message' => 'File not found !'], 404);
        }

        return new Response($img, 200, ['Content-type' => $type]);
    }
}
