<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/iide-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#E4492D',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#E4492D',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#E4492D',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#E4492D',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'mediatheque',
                'sectionTextColor' => '#E4492D'
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'movements_description',
            'types'           => ['movements'],
            'link' => [
                'sectionLinkStrKey' => 'newsletter.see_all_new_members',
                'sectionLinkUrl'   => 'movements',
                'sectionTextColor' => '#E4492D',
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items'       => [
                'comments' => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/iide-back/resources/assets/img/newsletter/comment.png',
                    'titleStrKey'        => 'newsletter.comments_statistic',
                ],
                'likes'    => [
                    'callback'           => function () {
                        return \Inside\Reaction\Models\Reaction::where('type',
                            'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/iide-back/resources/assets/img/newsletter/like.png',
                    'titleStrKey'        => 'newsletter.likes_statistic',
                ],
                'users'    => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Users::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/iide-back/resources/assets/img/newsletter/directory.png',
                    'titleStrKey'        => 'newsletter.users_statistic',
                ],
                'news'     => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/iide-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey'        => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#EE4130',
        'links' => [
            'facebook' => [
                'url' => '#',
            ],
            'twitter' => [
                'url' => '#',
            ],
            'linkedin' => [
                'url' => '#',
            ],
            'instagram' => [
                'url' => '#',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
