<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class AddProjectConstructionStartDetailFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('node', 'projects', 'construction_quarters');
        $this->getBridge()?->contentTypeDelete('construction_quarters');

        $this->migrateContent('projects');
        $this->finishUp();
    }
}
