<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\LegalEntities;
use Inside\Content\Models\Contents\Subsidiaries;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class switchLegalEntitiesWithSubsidiaries extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridgeType->contentTypeUpdate('subsidiaries', [
            'title' => [
                'fr' => 'Filiales de rattachement',
                'en' => 'Affiliated subsidiaries',
            ],
        ]);
        $bridgeType->changeFieldTitle(
            'users',
            'subsidiaries',
            [
                'fr' => 'Filiale de rattachement',
                'en' => 'Affiliated subsidiary',
            ]
        );
    }
}
