<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProjectsType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $fieldsToDelete = [
            'planner_fp',
            'number_of_lots_fp',
            'builder_fp',
            'building_floor_area_fp',
            'co_promoter_fp',
            'planner_fi',
            'number_of_lots_fi',
            'builder_fi',
            'building_floor_area_fi',
            'co_promoter_fi'
        ];

        $bridge = new BridgeContentType();

        foreach ($fieldsToDelete as $field) {
            $bridge->contentTypeDeleteField('node', 'projects', $field);
        }

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'planner',
            [
                'name' => 'planner',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 800,
                'title' => [
                    'fr' => 'Aménageur',
                    'en' => 'Planner',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 300,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            800
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'number_of_lots',
            [
                'name' => 'number_of_lots',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 801,
                'title' => [
                    'fr' => 'Nombre de lots',
                    'en' => 'Number of lots',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 420,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            801
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'builder',
            [
                'name' => 'builder',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 802,
                'title' => [
                    'fr' => 'Constructeur',
                    'en' => 'Builder',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 330,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            430
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'building_floor_area',
            [
                'name' => 'building_floor_area',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 803,
                'title' => [
                    'fr' => 'Surface constructible de plancher',
                    'en' => 'Buildable floor area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 390,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            803
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'co_promoter',
            [
                'name' => 'co_promoter',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 804,
                'title' => [
                    'fr' => 'Co promoteur',
                    'en' => 'Co promoteur',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 320,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            804
        );
    }

    public function down(): void
    {
    }
}
