<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class FixLeaseFieldInProjectsType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'lease',
            [
                'name' => 'lease',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 430,
                'title' => [
                    'fr' => 'Mise à bail',
                    'en' => 'lease',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 430,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            430
        );
    }

    public function down(): void
    {
    }
}
