<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddDeliveryFieldsOnProject extends Migration
{
    /**
     * @return void
     * @throws \Drupal\Core\Entity\EntityStorageException
     * @throws \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'delivery_month',
            [
                'name' => 'delivery_month',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 280,
                'title' => [
                    'fr' => 'Mois de livraison',
                    'en' => 'Month delivery',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 280,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::LIST_STRING_FIELD,
                'settings' => [
                    'cardinality' => 1,
                    'allowed_values' => [
                        '01' => [
                            'fr' => '01 - Janvier',
                            'en' => '01 - January',
                        ],
                        '02' => [
                            'fr' => '02 - Fevrier',
                            'en' => '02 - February',
                        ],
                        '03' => [
                            'fr' => '03 - Mars',
                            'en' => '03 - March',
                        ],
                        '04' => [
                            'fr' => '04 - Avril',
                            'en' => '04 - April',
                        ],
                        '05' => [
                            'fr' => '05 - Mai',
                            'en' => '05 - May',
                        ],
                        '06' => [
                            'fr' => '06 - Juin',
                            'en' => '06 - June',
                        ],
                        '07' => [
                            'fr' => '07 - Juillet',
                            'en' => '07 - July',
                        ],
                        '08' => [
                            'fr' => '08 - Août',
                            'en' => '08 - August',
                        ],
                        '09' => [
                            'fr' => '09 - Septembre',
                            'en' => '09 - September',
                        ],
                        '10' => [
                            'fr' => '10 - Octobre',
                            'en' => '10 - October',
                        ],
                        '11' => [
                            'fr' => '11 - Novembre',
                            'en' => '11 - November',
                        ],
                        '12' => [
                            'fr' => '12 - Décembre',
                            'en' => '12 - December',
                        ],
                    ],
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'delivery_year',
            [
                'name' => 'delivery_year',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 281,
                'title' => [
                  'fr' => 'Année de livraison',
                  'en' => 'Year delivery',
                ],
                'widget' => [
                  'type' => BridgeContentType::NUMBER_WIDGET,
                  'weight' => 281,
                  'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                  'cardinality' => 1,
                ],
            ]
        );

        $bridge->contentTypeDeleteField('node', 'projects', 'delivery_date_quarters');
        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'delivery_date_quarters',
            [
                'name' => 'delivery_quarter',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 279,
                'title' => [
                    'fr' => 'Trimestre de livraison',
                    'en' => 'Quarter delivery',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 279,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::LIST_STRING_FIELD,
                'settings' => [
                    'cardinality' => 1,
                    'allowed_values' => [
                        'T1' => [
                            'fr' => 'Trimestre 1',
                            'en' => 'Quarter 1',
                        ],
                        'T2' => [
                            'fr' => 'Trimestre 2',
                            'en' => 'Quarter 2',
                        ],
                        'T3' => [
                            'fr' => 'Trimestre 3',
                            'en' => 'Quarter 3',
                        ],
                        'T4' => [
                            'fr' => 'Trimestre 4',
                            'en' => 'Quarter 4',
                        ]
                    ],
                ],
            ]
        );
    }

    public function down(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'projects', 'delivery_month');
        $bridge->contentTypeDeleteField('node', 'projects', 'delivery_year');
        $bridge->contentTypeDeleteField('node', 'projects', 'delivery_quarter');
    }
}
